/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render.uv;

import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import cofh.repack.codechicken.lib.util.Copyable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class UV
implements Copyable<UV> {
    public double u;
    public double v;
    public int tex;

    public UV() {
    }

    public UV(double d, double d2) {
        this(d, d2, 0);
    }

    public UV(double d, double d2, int n) {
        this.u = d;
        this.v = d2;
        this.tex = n;
    }

    public UV(UV uV) {
        this(uV.u, uV.v, uV.tex);
    }

    public UV set(double d, double d2, int n) {
        this.u = d;
        this.v = d2;
        this.tex = n;
        return this;
    }

    public UV set(double d, double d2) {
        return this.set(d, d2, this.tex);
    }

    public UV set(UV uV) {
        return this.set(uV.u, uV.v, uV.tex);
    }

    @Override
    public UV copy() {
        return new UV(this);
    }

    public UV add(UV uV) {
        this.u += uV.u;
        this.v += uV.v;
        return this;
    }

    public UV multiply(double d) {
        this.u *= d;
        this.v *= d;
        return this;
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "UV(" + new BigDecimal(this.u, mathContext) + ", " + new BigDecimal(this.v, mathContext) + ")";
    }

    public UV apply(UVTransformation uVTransformation) {
        uVTransformation.apply(this);
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UV)) {
            return false;
        }
        UV uV = (UV)object;
        return this.u == uV.u && this.v == uV.v;
    }
}

